package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * In this RefreshHistory class implements the interface Serializable and
 * defines the entity and data mapping for the dbo.RefreshHistory Table in
 * the database.
 */
@Entity
@Table(name = "RefreshHistory", schema = "dbo")
public class RefreshHistory implements Serializable {

	private static final long serialVersionUID = -6802704341710760753L;

	@Id
	@Column(name = "Id", unique = true, nullable = false)
	//@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "Seq_Gen")
	//@SequenceGenerator(name = "Seq_Gen", sequenceName = "UserRefreshHistory_Id_Seq", allocationSize = 1)
	private int id;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "StartDate", length = 23, nullable = false)
	private Date startDate;

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "EndDate", length = 23)
	private Date endDate;

	@Column(name = "ScheduledBy", length = 50, nullable = false)
	private String scheduledBy;

	@Column(name = "Status", length = 50, nullable = false)
	private String status;

	@Column(name = "ErrorMessage", length = 500)
	private String errorMessage;
	
	@Column(name = "JobType", length = 50, nullable = false)
	private String jobType;
	

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the startDate
	 */
	public Date getStartDate() {
		return startDate;
	}

	/**
	 * @param startDate
	 *            the startDate to set
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	/**
	 * @return the endDate
	 */
	public Date getEndDate() {
		return endDate;
	}

	/**
	 * @param endDate
	 *            the endDate to set
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	/**
	 * @return the scheduledBy
	 */
	public String getScheduledBy() {
		return scheduledBy;
	}

	/**
	 * @param scheduledBy
	 *            the scheduledBy to set
	 */
	public void setScheduledBy(String scheduledBy) {
		this.scheduledBy = scheduledBy;
	}

	/**
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status
	 *            the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * @return the errorMessage
	 */
	public String getErrorMessage() {
		return errorMessage;
	}

	/**
	 * @param errorMessage
	 *            the errorMessage to set
	 */
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	/**
	 * @return the jobType
	 */
	public String getJobType() {
		return jobType;
	}

	/**
	 * @param jobType the jobType to set
	 */
	public void setJobType(String jobType) {
		this.jobType = jobType;
	}
	
	
}
